<?php
/**
 * isLoggedIn
 *
 * Copyright 2009-2011 by Shaun McCormick <shaun@modx.com>
 *
 * isLoggedIn is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * isLoggedIn is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * isLoggedIn; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @package login
 */
/**
 * MODx isLoggedIn Snippet. Will check to see if user is logged into the current
 * or specific context. If not, redirects to unauthorized page.
 *
 * @package login
 */
/* setup default properties */
$ctxs = !empty($ctxs) ? $ctxs : $modx->context->get('key');
if (!is_array($ctxs)) $ctxs = explode(',',$ctxs);

if (!$modx->user->hasSessionContext($ctxs)) {
    if (!empty($redirectTo)) {
        $redirectParams = !empty($redirectParams) ? $modx->fromJSON($redirectParams) : '';
        $url = $modx->makeUrl($redirectTo,'',$redirectParams,'full');
        $modx->sendRedirect($url);
    } else {
        $modx->sendUnauthorizedPage();
    }
}
return '';